﻿using System;
using System.Collections.Generic;
using HIPS.Web.Components.Cache;
using HIPS.Web.Model.AssistedRegistration;

namespace HIPS.Web.ModelInterface.AssistedRegistration
{
    public class CachedAssistedRegistrationReferenceRepository : IAssistedRegistrationReferenceRepository
    {
        private IAssistedRegistrationReferenceRepository ReferenceRepository { get; set; }
        private ICacheProvider CacheProvider { get; set; }
        private readonly string CacheKeyFormat;

        public CachedAssistedRegistrationReferenceRepository(
            IAssistedRegistrationReferenceRepository referenceRepository, 
            ICacheProvider cacheProvider,
            string cacheKeyPrefix = "")
        {
            ReferenceRepository = referenceRepository;
            CacheProvider = cacheProvider;
            CacheKeyFormat = cacheKeyPrefix + ".CachedAssistedRegistrationReferenceRepository.{0}";
        }

        public List<IdentityVerificationMethod> GetIdentityVerificationMethods()
        {
            return CacheProvider.GetOrSet(String.Format(CacheKeyFormat, "GetIdentityVerificationMethods()"),
                () => ReferenceRepository.GetIdentityVerificationMethods());
        }

        public List<IndigenousStatus> GetIndigenousStatuses()
        {
            return CacheProvider.GetOrSet(String.Format(CacheKeyFormat, "GetIndigenousStatuses()"),
                () => ReferenceRepository.GetIndigenousStatuses());
        }

        public List<IvcDeliveryMethod> GetIvcDeliveryMethods()
        {
            return CacheProvider.GetOrSet(String.Format(CacheKeyFormat, "GetIvcDeliveryMethods()"),
                () => ReferenceRepository.GetIvcDeliveryMethods());
        }

        public List<MedicareConsent> GetMedicareConsents()
        {
            return CacheProvider.GetOrSet(String.Format(CacheKeyFormat, "GetMedicareConsents()"),
                () => ReferenceRepository.GetMedicareConsents());
        }

        public List<Sex> GetSexes()
        {
            return CacheProvider.GetOrSet(String.Format(CacheKeyFormat, "GetSexes()"),
                () => ReferenceRepository.GetSexes());
        }

        /// <summary>
        ///     Performs application-defined tasks associated with freeing, releasing, or resetting unmanaged resources.
        /// </summary>
        public void Dispose()
        {
            if (ReferenceRepository != null)
            {
                ReferenceRepository.Dispose();
                ReferenceRepository = null;
            }
        }
    }
}